package gov.va.med.mhv.mrp.data.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.mrp.data.model.MyGoals;

@Repository
@Transactional(readOnly = true)
public interface MyGoalRepository extends JpaRepository<MyGoals, Long> {
	
	@Query("select m from MyGoals m where m.userProfileId = :userProfileId and completedDate is null order by m.priorityType, lower(m.goalName)")
	public List<MyGoals> findByUserProfileId(@Param("userProfileId") Long userProfileId);
	
	@Query("select m from MyGoals m where m.userProfileId = :userProfileId and completedDate is not null order by m.priorityType, lower(m.goalName)")
	public List<MyGoals> findCompletedByUserProfileId(@Param("userProfileId") Long userProfileId);
	
	@Query("select m from MyGoals m where m.userProfileId = :userProfileId and m.goalId = :goalId")
	public MyGoals findMyGoalById(@Param("userProfileId") Long userProfileId, @Param("goalId") Long goalId);
	
	@Query("select m from MyGoals m where m.userProfileId = :userProfileId and lower(m.goalName) = lower(:goalName)")
	public MyGoals findMyGoalByName(@Param("userProfileId") Long userProfileId, @Param("goalName") String goalName);
		
}
